/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.js.hyperlink;

import com.aptana.core.util.ArrayUtil;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.editor.common.AbstractThemeableEditor;
import com.aptana.editor.js.hyperlink.IJSHyperlink;
import com.aptana.editor.js.hyperlink.JSHyperlinkCollector;
import com.aptana.js.core.parsing.ast.JSParseRootNode;
import com.aptana.js.core.parsing.ast.JSTreeWalker;
import com.aptana.parsing.ast.IParseRootNode;
import java.util.Collection;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;

public class JSHyperlinkDetector
extends AbstractHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        return this.detectHyperlinks(this.getEditor(textViewer), region, canShowMultipleHyperlinks);
    }

    public IHyperlink[] detectHyperlinks(AbstractThemeableEditor editor, IRegion region, boolean canShowMultipleHyperlinks) {
        IParseRootNode ast;
        IHyperlink[] result = null;
        if (editor != null && region != null && (ast = editor.getAST()) instanceof JSParseRootNode) {
            result = this.processAST(editor, (JSParseRootNode)ast, region.getOffset());
        }
        if (!canShowMultipleHyperlinks && !ArrayUtil.isEmpty(result)) {
            result = new IHyperlink[]{result[0]};
        }
        return result;
    }

    private IHyperlink[] processAST(AbstractThemeableEditor editor, JSParseRootNode ast, int offset) {
        JSHyperlinkCollector collector = new JSHyperlinkCollector(editor, ast, offset);
        ast.accept((JSTreeWalker)collector);
        Collection<IJSHyperlink> result = collector.getHyperlinks();
        return CollectionsUtil.isEmpty(result) ? null : result.toArray(new IHyperlink[result.size()]);
    }

    protected AbstractThemeableEditor getEditor(ITextViewer textViewer) {
        AbstractThemeableEditor result = null;
        if (textViewer instanceof IAdaptable) {
            result = (AbstractThemeableEditor)((IAdaptable)textViewer).getAdapter(AbstractThemeableEditor.class);
        }
        return result;
    }
}

